IF EXISTS (SELECT * FROM sys.objects  WHERE [type] IN ('FN','P') AND  name = 'CF_Tar_Nro_Socio')
	DROP FUNCTION DBO.CF_Tar_Nro_Socio
GO



CREATE FUNCTION [dbo].[CF_Cbtes_Tar_Nro](@pId_Trans INT)
RETURNS VARCHAR(25)
AS
BEGIN

DECLARE @Tar_Nro				VARCHAR(25)
DECLARE @Id_Cond_Pago_Debito	SMALLINT
DECLARE @Id_Cond_Pago			SMALLINT
DECLARE @Id_Contrato			INT
DECLARE @Tar_Nro_Cbte			VARCHAR(25)
DECLARE @Tar_Nro_Contrato		VARCHAR(25)
DECLARE @Id_Cliente				INT
DECLARE @Tar_Nro_Cliente		VARCHAR(25)

SET @Id_Cond_Pago_Debito	= CONVERT(SMALLINT, dbo.CF_xParam('Cond_Pag_Debito'))
SET @Id_Cond_Pago			= ISNULL((SELECT Id_Cond_Pago FROM Cbtes WHERE Id_Trans = @pId_Trans),0)

IF(@Id_Cond_Pago_Debito = @Id_Cond_Pago  AND @Id_Cond_Pago != 0 )
BEGIN
	/*Busca directamente en los datos del Cbte*/
	SET @Tar_Nro_Cbte = (SELECT ISNULL(Tarjeta_Nro, '') FROM Cbtes WHERE Id_Trans = @pId_Trans)
	
	IF(@Tar_Nro_Cbte <> '')
	BEGIN
		SET @Tar_Nro = @Tar_Nro_Cbte
	END
END
ELSE
BEGIN
	/*Tiene que buscar si tiene una tarjeta cargada en el Contrato*/
	SET @Id_Contrato = (SELECT ISNULL(Id_Contrato, 0) FROM Cbtes WHERE Id_Trans = @pId_Trans)

	SET @Tar_Nro_Contrato = (SELECT ISNULL(Tar_Nro, '') FROM Contratos WHERE Id_Contrato = @Id_Contrato)

	IF(@Tar_Nro_Contrato <> '')
	BEGIN
		/*El Contrato tiene un Tipo de Tarjeta cargado*/
		SET @Tar_Nro = @Tar_Nro_Contrato
	END
	ELSE
	BEGIN
		/*El Contrato NO tiene un Tipo de Tarjeta cargado, tiene que revisar en la ficha del Socio de la cabecera del Cbte*/
		SET @Id_Cliente			= (SELECT ISNULL(Id_Cliente, 0) FROM Cbtes WHERE Id_Trans = @pId_Trans)
		
		IF(@Id_Cliente NOT IN (0, 1))
		BEGIN
			SET @Tar_Nro_Cliente = (SELECT ISNULL(Tar_Nro, '') FROM Clientes WHERE Id_Cliente = @Id_Cliente)
	
			IF(@Tar_Nro_Cliente <> '')
			BEGIN
				SET @Tar_Nro = @Tar_Nro_Cliente
			END
		END
	END
END

RETURN ISNULL(@Tar_Nro, '')
END
